<?php
/* --------------------------------------------------------------
 CloudPlanLoader.php 2024-06-30
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2024 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Admin\Layout\Renderer\Loaders;

use Gambio\Core\TemplateEngine\LayoutData;
use Gambio\Core\TemplateEngine\Loader;

class CloudPlanLoader implements Loader
{
    public function load(LayoutData $data): void
    {
        $data->assign('cloudPlan', $this->getPlan());
    }
    
    private function getPlan(): string
    {
        if(file_exists(DIR_FS_CATALOG . 'debug/.startup'))
        {
            return 'startup';
        }
        
        else if(file_exists(DIR_FS_CATALOG . 'debug/.small_business'))
        {
            return 'smallBusiness';
        }
        
        else if(file_exists(DIR_FS_CATALOG . 'debug/.professional'))
        {
            return 'professional';
        }
        
        return 'none';
    }
}